<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
    <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>

    <xsl:template match="/">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
            <fo:layout-master-set>
                <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="1.5cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
                    <fo:region-body/>
                </fo:simple-page-master>
            </fo:layout-master-set>

            <fo:page-sequence master-reference="simpleA4">
                <fo:flow flow-name="xsl-region-body">
			        <xsl:apply-templates select="centre"/>
				</fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template match="centre">
        <xsl:apply-templates select="available-sessions/component-list/component-version-list/candidates"/>
    </xsl:template>

    <xsl:template match="component-list">
        <fo:table-row>
            <fo:table-cell>
                <fo:block><fo:inline font-weight="bold">Paper: </fo:inline>
                    <xsl:value-of select="name"/>
                    <xsl:call-template name="getCentreNumber"/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="available-sessions">
        <fo:table-row>
            <fo:table-cell>
                <fo:block><fo:inline font-weight="bold">Exam: </fo:inline>
                    <xsl:value-of select="name"/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="candidates">
        <fo:block font-size="12pt" break-before="page">
			<fo:block space-after="7mm">
				<fo:external-graphic src="url('storage/component-bundles/pdf/pdf_header.gif')"/>
			</fo:block>

            <fo:table table-layout="fixed">
                <fo:table-column column-width="8.5cm"/>
                <fo:table-column column-width="8.5cm"/>
                <fo:table-body>
                    <fo:table-row font-size="14pt">
                        <fo:table-cell number-columns-spanned="2" >
                            <fo:block><fo:inline font-weight="bold">Candidate: </fo:inline>
                                <xsl:value-of select="concat(last-name,', ',first-name)"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row font-size="13pt">
                        <fo:table-cell>
                            <fo:block><fo:inline font-weight="bold">Candidate Number: </fo:inline>
                                <xsl:value-of select="candidate-number"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block><fo:inline font-weight="bold">Password: </fo:inline>
                                <xsl:value-of select="access-token"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block space-before="0mm"><fo:inline font-weight="bold">Date of Birth </fo:inline>
                                <xsl:call-template name="reverseDate">
                                    <xsl:with-param name="date" select="substring-before(date-of-birth, 'T')"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block space-after="0mm"><fo:inline font-weight="bold">Gender: </fo:inline>
                                <xsl:value-of select="gender"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                   <!-- <fo:table-row>
                        <fo:table-cell>
                            <fo:block><fo:inline font-weight="bold">Qualification: </fo:inline>
                                <xsl:call-template name="getExam"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>-->
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block><fo:inline font-weight="bold">Paper: </fo:inline>
                                <xsl:call-template name="getPaper"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block><fo:inline font-weight="bold">Centre: </fo:inline>
                                <xsl:call-template name="getCentreNumber"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block><fo:inline font-weight="bold">Examination Date: </fo:inline>
                                <xsl:call-template name="getExamDate"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </fo:block>
        <fo:block space-before="7mm">
        You may use this paper to write any notes, but <fo:inline font-weight="bold">all</fo:inline> answers must be entered on the <fo:inline font-weight="bold">computer</fo:inline>. This paper will be collected by the invigilator at the end of the test.
        </fo:block>
    </xsl:template>

    <!-- returns dd/mm/yyyy from yyyy-mm-dd -->
    <xsl:template name="reverseDate">
        <xsl:param name="date"/>
        <xsl:choose>
            <xsl:when test="contains($date,'-')">
                <xsl:call-template name="reverseDate">
                    <xsl:with-param name="date" select="substring-after($date,'-')"/>
                </xsl:call-template>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="substring-before($date,'-')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$date"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getCentreNumber">
        <xsl:for-each select="ancestor::*">
            <xsl:choose>
                <xsl:when test="starts-with(name(), 'centre')">
                    <xsl:value-of select="number"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="getPaper">
        <xsl:for-each select="ancestor::*">
            <xsl:choose>
                <xsl:when test="starts-with(name(), 'component-list')">
                    <xsl:value-of select="name"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="getExam">
        <xsl:for-each select="ancestor::*">
            <xsl:choose>
                <xsl:when test="starts-with(name(), 'available-sessions')">
                    <xsl:value-of select="name"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="getExamDate">
        <xsl:for-each select="ancestor::*">
            <xsl:choose>
                <xsl:when test="starts-with(name(), 'centre')">
                    <xsl:call-template name="reverseDate">
                        <xsl:with-param name="date" select="substring-before(uccs-time, 'T')"/>
                    </xsl:call-template>
                    <xsl:value-of select="concat('',' ',concat(substring-before(substring-after(uccs-time, 'T'),':'), ':', substring-before(substring-after(uccs-time, ':'),':')))"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>